/*:
 * @target MZ
 * @plugindesc [HS] PKD_Spine2DPlayer 用：同じ ID の Spine 立ち絵を二重生成しないための簡易ガード
 * @author HS
 * @help
 * PKD_Spine2DPlayer.js より下に配置してください。
 *
 * 概要:
 * - CreateSAnim(id, filename, x, y) をラップして、
 *   すでに同じ id の Spine が存在する場合は「再利用」します。
 * - これにより、ロード時などにイベント側で CreateSAnim が
 *   複数回呼ばれても、画面上に2重表示されるのを防ぎます。
 *
 * 注意:
 * - 別のファイル名で差し替えたい場合は、事前に RemoveSAnim(id)
 *   を呼んだうえで CreateSAnim してください。
 */

(() => {
  if (!window.CreateSAnim) return;

  const _CreateSAnim = window.CreateSAnim;

  window.CreateSAnim = function(id, filename, x = 0, y = 0) {
    try {
      if ($gameTemp && $gameTemp.pGetSpineAnimationSprite) {
        const existing = $gameTemp.pGetSpineAnimationSprite(id);

        // すでに同じ ID の Spine が生きている場合
        if (existing && typeof existing.isValid === "function" && existing.isValid()) {

          // ファイル名が同じ or filename 未指定 → そのまま再利用
          if (!filename || existing.filename === filename) {
            if (typeof existing.setPosition === "function") {
              existing.setPosition(x, y);
            } else {
              existing.x = x;
              existing.y = y;
            }
            return existing;
          }

          // 別ファイルに差し替えようとしている場合は、古い方を消す
          if (typeof existing.remove === "function") {
            existing.remove();
          } else {
            if (existing.parent) {
              existing.parent.removeChild(existing);
            }
            if (typeof $gameTemp.pRemoveSpineAnimationSprite === "function") {
              $gameTemp.pRemoveSpineAnimationSprite(id);
            }
          }
        }
      }
    } catch (e) {
      console.warn(e);
    }

    // ここまでで再利用しなかった場合は、通常どおり新規生成
    return _CreateSAnim.call(this, id, filename, x, y);
  };
})();
